/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.block;

import com.breakinblocks.plonk.common.registry.RegistryTileEntities;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.ItemUtils;
import com.breakinblocks.plonk.common.util.WorldUtils;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.common.ForgeMod;

public class BlockPlacedItems
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final ThreadLocal<Boolean> picking = ThreadLocal.withInitial(() -> false);

    public BlockPlacedItems(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return BlockPlacedItems.m_152132_(pBlockEntityType, RegistryTileEntities.placed_items, TilePlacedItems::clientTick);
        }
        return BlockPlacedItems.m_152132_(pBlockEntityType, RegistryTileEntities.placed_items, TilePlacedItems::serverTick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return WorldUtils.withTile(worldIn, pos, TilePlacedItems.class, tile -> {
            Entity entity;
            if (this.picking.get().booleanValue()) {
                return tile.getContentsBoxes().getSelectionShape();
            }
            int slot = -1;
            Entity entity2 = entity = context instanceof EntityCollisionContext ? ((EntityCollisionContext)context).m_193113_() : null;
            if (entity instanceof Player) {
                slot = this.getPickedSlot((TilePlacedItems)((Object)tile), pos, (Player)entity);
            }
            return slot >= 0 ? tile.getContentsBoxes().getSelectionShapeById(slot + 1) : tile.getContentsBoxes().getSelectionShape();
        }, Shapes::m_83040_);
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return WorldUtils.withTile(worldIn, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().getCollisionShape(), Shapes::m_83040_);
    }

    @Deprecated
    public VoxelShape m_5909_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof Container) {
                if (!worldIn.restoringBlockSnapshots) {
                    Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPickedSlot(TilePlacedItems tile, BlockPos pos, Player player) {
        HitResult traceResult;
        if (this.picking.get().booleanValue()) {
            return -1;
        }
        double blockReachDistance = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_();
        float partialTicks = 0.0f;
        try {
            this.picking.set(true);
            traceResult = player.m_19907_(blockReachDistance, partialTicks, false);
        }
        finally {
            this.picking.set(false);
        }
        if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitVec = traceResult.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            int index = tile.getContentsBoxes().getSelectionIndexFromHitVec(hitVec);
            return index <= 0 ? 0 : index - 1;
        }
        return -1;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TilePlacedItems tile = (TilePlacedItems)worldIn.m_7702_(pos);
        if (tile == null) {
            return InteractionResult.SUCCESS;
        }
        int slot = this.getPickedSlot(tile, pos, player);
        if (slot >= 0) {
            ItemStack stack = tile.m_8020_(slot);
            if (!stack.m_41619_()) {
                if (player.m_6144_()) {
                    tile.rotateSlot(slot);
                } else {
                    ItemUtils.dropItemOnEntity((LivingEntity)player, stack);
                    tile.m_6836_(slot, ItemStack.f_41583_);
                }
                tile.m_6596_();
                tile.clean();
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        TilePlacedItems tile = (TilePlacedItems)worldIn.m_7702_(pos);
        Objects.requireNonNull(tile);
        Direction facing = (Direction)worldIn.m_8055_(pos).m_61143_((Property)FACING);
        float yaw = placer.m_146908_() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = Math.round(yaw / 90.0f) % 4;
        rotation = facing == Direction.UP ? (rotation + 2) % 4 : (facing == Direction.DOWN ? 4 - rotation : 0);
        tile.setTileRotation(rotation);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return RegistryTileEntities.placed_items.m_155264_(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return WorldUtils.withTile(world, pos, TilePlacedItems.class, tile -> {
            int slot = this.getPickedSlot((TilePlacedItems)((Object)tile), pos, player);
            return slot >= 0 ? tile.m_8020_(slot) : ItemStack.f_41583_;
        }, () -> ItemStack.f_41583_);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }

    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){

            public boolean addHitEffects(BlockState state, Level Level2, HitResult target, ParticleEngine manager) {
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                return true;
            }
        });
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return super.getSoundType(state, world, pos, entity);
    }
}

